# coding:utf-8
import arcpy
import sys
import traceback

# 消息写出
def outputMsg(msg):
    arcpy.AddMessage(msg)

def main():
    try:
        database = sys.argv[1]  # 数据库路径
        checkLayerName = sys.argv[2]  # 检查图层名称
        checkLayerWhere = sys.argv[3]  # 相关图层筛选条件
        relatedLayerName = sys.argv[4]  # 相关图层名称
        relatedLayerWhere = sys.argv[5]  # 相关图层筛选条件
        spatialRelation = sys.argv[6]  # 空间关系
        constraintCondition = sys.argv[7]  # 点点关系约束条件(重合时)
        checkBuffer = sys.argv[8]  # 检查缓冲值
        filterObjects = sys.argv[9]  # 多个过滤对象(包含图层名称和筛选条件)需解析
        # filterLayerName = sys.argv[9]  # 过滤图层名称
        # filterLayerWhere = sys.argv[10]  # 过滤图层筛选条件
        filterBuffer = sys.argv[10]  # 过滤缓冲值
        maxAllowResultNum = sys.argv[11]  # 消息输出最大数量

        # database = arcpy.GetParameter(0)  # 数据库路径
        # checkLayerName = arcpy.GetParameter(1)  # 检查图层名称
        # checkLayerWhere = arcpy.GetParameter(2)  # 相关图层筛选条件
        # relatedLayerName = arcpy.GetParameter(3)  # 相关图层名称
        # relatedLayerWhere = arcpy.GetParameter(4)  # 相关图层筛选条件
        # spatialRelation = arcpy.GetParameter(5)  # 空间关系
        # constraintCondition = arcpy.GetParameter(6)  # 点点关系约束条件(重合时)
        # checkBuffer = arcpy.GetParameter(7)  # 检查缓冲值
        # filterLayerName = arcpy.GetParameter(8)  # 过滤图层名称
        # filterLayerWhere = arcpy.GetParameter(9)  # 过滤图层筛选条件
        # filterBuffer = arcpy.GetParameter(10)  # 过滤缓冲值

        # database = 'E:\\1、测试数据及相关资料\\2023年城市监测\\测试数据\\点点关系测试.gdb'
        # checkLayerName = 'AAAP'
        # checkLayerWhere = ''
        # relatedLayerName = 'BBBP'
        # relatedLayerWhere = ''
        # checkBuffer = 0
        # spatialRelation = '重叠'
        # constraintCondition = '一一对应'

        arcpy.env.workspace = database

        if checkLayerWhere == 'None':
            checkLayerWhere = ''
        else:
            checkLayerWhere = checkLayerWhere.replace("!?", " ")
        if relatedLayerWhere == 'None':
            relatedLayerWhere = ''
        else:
            relatedLayerWhere = relatedLayerWhere.replace("!?", " ")

        # 多个过滤对象
        filterObjectArr = filterObjects.split(';')
        for index in range(len(filterObjectArr)):
            filterObjectArr[index] = filterObjectArr[index].replace("!?", " ")

        checkLayer = arcpy.MakeFeatureLayer_management(checkLayerName, 'checkLayer', checkLayerWhere)
        relatedLayer = arcpy.MakeFeatureLayer_management(relatedLayerName, 'relatedLayer', relatedLayerWhere)

        # 从VS2019传过来的字符串默认是gb2312编码，需要转换比较
        spatialRelation = spatialRelation.decode('gb2312').encode('utf-8')
        constraintCondition = constraintCondition.decode('gb2312').encode('utf-8')

        resultNum = 0  # 输出消息计数
        if spatialRelation == '重叠':
            if constraintCondition == '一一对应':  # 选择检查图层要素中，不重叠的要素；选择相关图层要素中，不重叠的要素
                arcpy.SelectLayerByLocation_management('checkLayer', 'WITHIN_A_DISTANCE', 'relatedLayer', checkBuffer,
                                                       'NEW_SELECTION')
                arcpy.SelectLayerByLocation_management('checkLayer', '', '', checkBuffer, 'SWITCH_SELECTION')
                if filterObjects != 'None':
                    for filterObject in filterObjectArr:  # 排除过滤对象
                        filterList = filterObject.split(':')
                        filterLayerName = filterList[0]
                        filterLayerWhere = filterList[1]
                        if filterLayerWhere == 'None':
                            filterLayerWhere = ''
                        if arcpy.Exists('filterLayer') == False:
                            arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                        arcpy.SelectLayerByLocation_management('checkLayer', 'WITHIN_A_DISTANCE', 'filterLayer',
                                                               filterBuffer, 'REMOVE_FROM_SELECTION')
                fields = ['ObjectID']
                outputMsg('检查图层意见OID')

                with arcpy.da.SearchCursor('checkLayer', fields) as cursor:
                    for row in cursor:
                        resultNum += 1
                        if resultNum > int(maxAllowResultNum):
                            return
                        outputMsg(row[0])
                arcpy.SelectLayerByAttribute_management('checkLayer','NEW_SELECTION','')  # 清空检查层的选择要素

                arcpy.SelectLayerByLocation_management('relatedLayer', 'WITHIN_A_DISTANCE', 'checkLayer', checkBuffer,
                                                       'NEW_SELECTION')
                arcpy.SelectLayerByLocation_management('relatedLayer', '', '', checkBuffer, 'SWITCH_SELECTION')
                if filterObjects != 'None':
                    for filterObject in filterObjectArr:  # 排除过滤对象
                        filterList = filterObject.split(':')
                        filterLayerName = filterList[0]
                        filterLayerWhere = filterList[1]
                        if filterLayerWhere == 'None':
                            filterLayerWhere = ''
                        if arcpy.Exists('filterLayer') == False:
                            arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                        arcpy.SelectLayerByLocation_management('relatedLayer', 'WITHIN_A_DISTANCE', 'filterLayer',
                                                               filterBuffer, 'REMOVE_FROM_SELECTION')
                outputMsg('相关图层意见OID')
                with arcpy.da.SearchCursor('relatedLayer', fields) as cursor:
                    for row in cursor:
                        resultNum += 1
                        if resultNum > int(maxAllowResultNum):
                            return
                        outputMsg(row[0])

            elif constraintCondition == '包含对应':  # 检查图层的点要素是包含相关图层的点要素，选择相关图层要素中，不重叠的要素
                arcpy.SelectLayerByLocation_management('relatedLayer', 'WITHIN_A_DISTANCE', 'checkLayer', checkBuffer,
                                                       'NEW_SELECTION')
                arcpy.SelectLayerByLocation_management('relatedLayer', '', '', checkBuffer, 'SWITCH_SELECTION')
                if filterObjects != 'None':
                    for filterObject in filterObjectArr:  # 排除过滤对象
                        filterList = filterObject.split(':')
                        filterLayerName = filterList[0]
                        filterLayerWhere = filterList[1]
                        if filterLayerWhere == 'None':
                            filterLayerWhere = ''
                        if arcpy.Exists('filterLayer') == False:
                            arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                        arcpy.SelectLayerByLocation_management('relatedLayer', 'WITHIN_A_DISTANCE', 'filterLayer',
                                                               filterBuffer, 'REMOVE_FROM_SELECTION')
                fields = ['ObjectID']
                outputMsg('相关图层意见OID')
                with arcpy.da.SearchCursor('relatedLayer', fields) as cursor:
                    for row in cursor:
                        resultNum += 1
                        if resultNum > int(maxAllowResultNum):
                            return
                        outputMsg(row[0])

            else:  # 被包含对应，检查图层的点要素是被相关图层的点要素包含，选择检查图层要素中，不重叠的要素
                arcpy.SelectLayerByLocation_management('checkLayer', 'WITHIN_A_DISTANCE', 'relatedLayer', checkBuffer,
                                                       'NEW_SELECTION')
                arcpy.SelectLayerByLocation_management('checkLayer', '', '', checkBuffer, 'SWITCH_SELECTION')
                if filterObjects != 'None':
                    for filterObject in filterObjectArr:  # 排除过滤对象
                        filterList = filterObject.split(':')
                        filterLayerName = filterList[0]
                        filterLayerWhere = filterList[1]
                        if filterLayerWhere == 'None':
                            filterLayerWhere = ''
                        if arcpy.Exists('filterLayer') == False:
                            arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                        arcpy.SelectLayerByLocation_management('checkLayer', 'WITHIN_A_DISTANCE', 'filterLayer',
                                                               filterBuffer, 'REMOVE_FROM_SELECTION')
                fields = ['ObjectID']
                outputMsg('检查图层意见OID')
                with arcpy.da.SearchCursor('checkLayer', fields) as cursor:
                    for row in cursor:
                        resultNum += 1
                        if resultNum > int(maxAllowResultNum):
                            return
                        outputMsg(row[0])

        else:  # 相离情况(选择检查图层要素中，重叠的要素)
            arcpy.SelectLayerByLocation_management('checkLayer', 'WITHIN_A_DISTANCE', 'relatedLayer', checkBuffer,
                                                   'NEW_SELECTION')
            if filterObjects != 'None':
                for filterObject in filterObjectArr:  # 排除过滤对象
                    filterList = filterObject.split(':')
                    filterLayerName = filterList[0]
                    filterLayerWhere = filterList[1]
                    if filterLayerWhere == 'None':
                        filterLayerWhere = ''
                    if arcpy.Exists('filterLayer') == False:
                        arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                    arcpy.SelectLayerByLocation_management('checkLayer', 'WITHIN_A_DISTANCE', 'filterLayer',
                                                           filterBuffer, 'REMOVE_FROM_SELECTION')
            fields = ['ObjectID']
            outputMsg('检查图层意见OID')
            with arcpy.da.SearchCursor('checkLayer', fields) as cursor:
                for row in cursor:
                    resultNum += 1
                    if resultNum > int(maxAllowResultNum):
                        return
                    outputMsg(row[0])

        # arcpy.CopyFeatures_management('checkLayer', 'checkFeatureClass')
        # arcpy.CopyFeatures_management('relatedLayer', 'relatedFeatureClass')
    except Exception as e:
        outputMsg('错误意见')
        # outputMsg(e.message)
        # msg = traceback.format_exc()
        # outputMsg(msg)
        traceback.print_exc()

if __name__ == "__main__":
    main()